/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.DataType;
import java.util.ArrayList;
import java.util.List;

public class RecordIdEqCondition
implements Condition {
    private final RecordId id;
    private final List<String> idColumns = new ArrayList<String>();

    public RecordIdEqCondition(RecordId id) {
        this.id = id;
    }

    @Override
    public String toSql(QueryContext queryContext) {
        TableSchema table = queryContext.getRootTable();
        if (!table.hasPrimaryKey()) {
            throw new IllegalStateException("Cannot apply RecordIdEqCondition because table [" + table + "] does not have a primary key");
        }
        this.idColumns.clear();
        PrimaryKey pk = table.getPrimaryKey();
        if (!pk.isComposite()) {
            if (this.id.isComposite()) {
                throw new IllegalStateException("");
            }
            this.idColumns.add(pk.getColumn());
        } else {
            this.idColumns.addAll(this.id.getCompositeValues().keySet());
        }
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (String column : this.idColumns) {
            sql.append(queryContext.getColumnAlias(column)).append("=?");
            if (i < this.idColumns.size() - 1) {
                sql.append(" AND ");
            }
            ++i;
        }
        if (i > 1) {
            sql.insert(0, "(").append(")");
        }
        return sql.toString();
    }

    @Override
    public QueryParameter[] getParameters(QueryContext queryContext) {
        Object[] values = !this.id.isComposite() ? new Object[]{this.id.getSingleValue()} : this.id.getCompositeValues().values().toArray();
        QueryParameter[] parameters = new QueryParameter[this.idColumns.size()];
        for (int i = 0; i < this.idColumns.size(); ++i) {
            String column = this.idColumns.get(i);
            DataType type = queryContext.getTypeOf(column);
            parameters[i] = new QueryParameter(values[i], type);
        }
        return parameters;
    }
}

