/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.type.DataType;
import org.springframework.util.Assert;

class OperatorCondition
implements Condition {
    private final String column;
    private final Object value;
    private final Operator operator;

    public OperatorCondition(String column, Operator operator, Object value) {
        Assert.notNull((Object)value, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public String toSql(QueryContext queryContext) {
        String alias = queryContext.getColumnAlias(this.column);
        StringBuilder sql = new StringBuilder().append(alias).append(this.operator.getOp()).append("?");
        return sql.toString();
    }

    @Override
    public QueryParameter[] getParameters(QueryContext queryContext) {
        DataType type = queryContext.getTypeOf(this.column);
        return new QueryParameter[]{new QueryParameter(this.value, type)};
    }

    public static enum Operator {
        EQ("="),
        LE("<="),
        GE(">="),
        LT("<"),
        GT(">");

        private String op;

        private Operator(String op) {
            this.op = op;
        }

        private String getOp() {
            return this.op;
        }
    }
}

