/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type.hibernate;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherTypeDescriptor
implements SqlTypeDescriptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final OtherTypeDescriptor INSTANCE = new OtherTypeDescriptor();

    protected OtherTypeDescriptor() {
    }

    public int getSqlType() {
        return 1111;
    }

    public boolean canBeRemapped() {
        return true;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        throw new IllegalStateException("Binding query parameters with UnknownType is not supported");
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                Object value = null;
                try {
                    value = rs.getObject(name);
                }
                catch (SQLException e) {
                    OtherTypeDescriptor.this.logger.debug("Could not read column [{}] value as Object from ResultSet", (Object)name);
                    try {
                        value = rs.getString(name);
                    }
                    catch (SQLException e1) {
                        OtherTypeDescriptor.this.logger.warn("Could not read column [{}] value as Object or String from ResultSet", (Object)name);
                        return null;
                    }
                }
                return javaTypeDescriptor.wrap(value, options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return null;
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return null;
            }
        };
    }
}

