/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.suncode.dbexplorer.database.internal.type.HibernateDataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.IntegerDataType;
import com.suncode.dbexplorer.database.type.NativeType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.NumberUtils;

public class IntegerDataTypeHandler
extends HibernateDataTypeHandler {
    @Override
    public DataType create(NativeType nativeType) {
        return new IntegerDataType(nativeType);
    }

    @Override
    protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
        if (value instanceof Number) {
            return NumberUtils.convertNumberToTargetClass((Number)((Number)value), targetClass);
        }
        if (value instanceof String) {
            return NumberUtils.parseNumber((String)((String)value), targetClass);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Type resolveHibernateType(DataType dataType) {
        int sqlType = dataType.getNativeType().getSqlType();
        switch (sqlType) {
            case -6: 
            case 5: {
                return StandardBasicTypes.SHORT;
            }
            case 4: {
                return StandardBasicTypes.INTEGER;
            }
            case -5: {
                return StandardBasicTypes.LONG;
            }
        }
        throw new IllegalStateException();
    }
}

