/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.query.AbstractQuery;
import com.suncode.dbexplorer.database.internal.query.support.BuildCreateQueryOracle;
import com.suncode.dbexplorer.database.internal.query.support.BuildCreateQueryPostgres;
import com.suncode.dbexplorer.database.internal.query.support.BuildCreateQuerySqlserver;
import com.suncode.dbexplorer.database.internal.query.support.BuildSqlQuery;
import com.suncode.dbexplorer.database.query.CreateQuery;
import com.suncode.dbexplorer.database.type.BasicDataType;
import com.suncode.dbexplorer.database.type.support.TypeConventer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.NativeQuery;
import org.springframework.util.Assert;

public class CreateQueryImpl
extends AbstractQuery
implements CreateQuery {
    private List<Column> columns = new ArrayList<Column>();
    private String schemaName;
    private String tableName;
    private DatabaseType database;
    private Set<Integer> primaryKeyIndexes = new HashSet<Integer>();
    private Map<String, String[]> foreignKeys = new HashMap<String, String[]>();

    public CreateQueryImpl(DatabaseSession session, DatabaseImplementor implementor) {
        super(session, implementor);
    }

    @Override
    public CreateQuery table(String table) {
        return this.table(this.session.getDatabase().getDefaultSchemaName(), table);
    }

    @Override
    public CreateQuery table(String schema, String table) {
        Assert.hasText((String)schema, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        String driver = this.implementor.getDriverClass().getName();
        this.database = DatabaseType.parseScheme(driver);
        this.schemaName = schema;
        this.tableName = table;
        return this;
    }

    @Override
    public CreateQuery column(String name, BasicDataType dataType) {
        return this.column(name, dataType, true, false);
    }

    @Override
    public CreateQuery column(String name, BasicDataType dataType, boolean nullable) {
        return this.column(name, dataType, nullable, false);
    }

    @Override
    public CreateQuery column(String name, BasicDataType dataType, boolean nullable, boolean autoincrement) {
        Assert.hasText((String)name, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        String type = TypeConventer.convert(dataType, this.database);
        this.columns.add(new Column(name, type, nullable, autoincrement));
        return this;
    }

    @Override
    public CreateQuery setAsPrimary() {
        this.primaryKeyIndexes.add(this.columns.size() - 1);
        return this;
    }

    @Override
    public CreateQuery setAsForeign(String foreignTableName, String foreignColumnName) {
        String columnName = this.columns.get(this.columns.size() - 1).getName();
        this.foreignKeys.put(columnName, new String[]{columnName, foreignTableName, foreignColumnName});
        return this;
    }

    @Override
    public int execute() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.buildSql());
        NativeQuery sqlQuery = this.session.hibernateSession().createSQLQuery(sql.toString());
        return sqlQuery.executeUpdate();
    }

    private String buildSql() {
        StringBuilder sql = new StringBuilder("CREATE TABLE " + this.schemaName + "." + this.tableName + " ( \n");
        if (this.database == DatabaseType.POSTGRES) {
            BuildCreateQueryPostgres buildSqlQuery = new BuildCreateQueryPostgres(this.tableName, this.columns, this.primaryKeyIndexes, this.foreignKeys);
            sql.append(((BuildSqlQuery)buildSqlQuery).buildSql());
        } else if (this.database == DatabaseType.ORACLE) {
            BuildCreateQueryOracle buildSqlQuery = new BuildCreateQueryOracle(this.tableName, this.columns, this.primaryKeyIndexes, this.foreignKeys);
            sql.append(((BuildSqlQuery)buildSqlQuery).buildSql());
        } else if (this.database == DatabaseType.SQLSERVER) {
            BuildCreateQuerySqlserver buildSqlQuery = new BuildCreateQuerySqlserver(this.tableName, this.columns, this.primaryKeyIndexes, this.foreignKeys);
            sql.append(((BuildSqlQuery)buildSqlQuery).buildSql());
        }
        return sql.toString();
    }

    public class Column {
        private String name;
        private String type;
        private boolean nullable;
        private boolean autoincrement;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isAutoincrement() {
            return this.autoincrement;
        }

        public Column(String name, String type, boolean nullable, boolean autoincrement) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.autoincrement = autoincrement;
        }
    }
}

