/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.postgres;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.ConnectionUrlResolver;
import org.springframework.stereotype.Component;

@Component
public class PostgresConnectionUrlResolver
implements ConnectionUrlResolver {
    @Override
    public String resolve(ConnectionString connectionString) {
        StringBuilder url = new StringBuilder("jdbc:postgresql://");
        url.append(connectionString.getHost());
        Integer port = connectionString.getPort();
        if (port != null) {
            url.append(":").append(port);
        }
        url.append("/");
        if (connectionString.catalogSpecified()) {
            url.append(connectionString.getCatalog());
            if (connectionString.schemaSpecified()) {
                url.append("?currentSchema=").append(connectionString.getSchema());
            }
        }
        return url.toString();
    }
}

