/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset;

import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.permissions.ConfigurationTablesSetPermissionConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.permissions.ConfigurationTablesSetPermissionDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.tables.ConfigurationTablesSetTableConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.tables.ConfigurationTablesSetTableDto;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationTablesSetConverter {
    private final ConfigurationTablesSetTableConverter configurationTablesSetTableConverter;
    private final ConfigurationTablesSetPermissionConverter configurationTablesSetPermissionConverter;

    public List<ConfigurationTablesSetDto> convertToDto(Set<TablesSet> tablesSets) {
        return tablesSets.stream().map(this::convertToDto).collect(Collectors.toList());
    }

    public ConfigurationTablesSetDto convertToDto(TablesSet tablesSet) {
        ConfigurationTablesSetDto tableSetDto = new ConfigurationTablesSetDto(tablesSet.getName(), tablesSet.getName());
        List<ConfigurationTablesSetTableDto> tables = this.configurationTablesSetTableConverter.convertToDto(tablesSet.getTables());
        tableSetDto.getTables().getList().addAll(tables);
        List<ConfigurationTablesSetPermissionDto> permissions = this.configurationTablesSetPermissionConverter.convertToDto(tablesSet.getPermissions());
        tableSetDto.getPermissions().getList().addAll(permissions);
        return tableSetDto;
    }

    public TablesSet convertToEntity(ConfigurationTablesSetDto tablesSetDto, List<User> allUsersInBase, List<UserGroup> allGroupsInBase) {
        TablesSet tablesSet = new TablesSet(tablesSetDto.getName());
        if (tablesSetDto.getTables().getMetadata().isSelected()) {
            this.addTables(tablesSetDto.getTables().getList(), tablesSet);
        }
        if (tablesSetDto.getPermissions().getMetadata().isSelected()) {
            this.addPermissions(tablesSetDto.getPermissions().getList(), tablesSet, allUsersInBase, allGroupsInBase);
        }
        return tablesSet;
    }

    private void addTables(List<ConfigurationTablesSetTableDto> tablesSetDtos, TablesSet tablesSet) {
        for (ConfigurationTablesSetTableDto tableDto : tablesSetDtos) {
            if (!tableDto.getMetadata().isSelected()) continue;
            tablesSet.getTables().add(this.configurationTablesSetTableConverter.convertToEntity(tableDto));
        }
    }

    private void addPermissions(List<ConfigurationTablesSetPermissionDto> permissionDtos, TablesSet tablesSet, List<User> allUsersInBase, List<UserGroup> allGroupsInBase) {
        for (ConfigurationTablesSetPermissionDto permissionDto : permissionDtos) {
            Optional<AccessResource> accessResource;
            if (!permissionDto.getMetadata().isSelected() || !(accessResource = this.getAccessResource(permissionDto, allUsersInBase, allGroupsInBase)).isPresent()) continue;
            TablesSetPermission permission = this.configurationTablesSetPermissionConverter.convertToEntity(permissionDto, tablesSet, accessResource.get());
            tablesSet.getPermissions().add(permission);
        }
    }

    private Optional<AccessResource> getAccessResource(ConfigurationTablesSetPermissionDto permissionDto, List<User> allUsersInBase, List<UserGroup> allGroupsInBase) {
        if (permissionDto.getResourceType() == AccessResource.ResourceType.USER) {
            return this.getAccessResourceForUser(permissionDto, allUsersInBase);
        }
        return this.getAccessResourceForGroup(permissionDto, allGroupsInBase);
    }

    private Optional<AccessResource> getAccessResourceForUser(ConfigurationTablesSetPermissionDto permissionDto, List<User> allUsersInBase) {
        Optional<User> userInBase = allUsersInBase.stream().filter(user -> user.getUserName().equals(permissionDto.getResource())).findFirst();
        return userInBase.map(AccessResource::new);
    }

    private Optional<AccessResource> getAccessResourceForGroup(ConfigurationTablesSetPermissionDto permissionDto, List<UserGroup> allGroupsInBase) {
        Optional<UserGroup> groupInBase = allGroupsInBase.stream().filter(group -> group.getName().equals(permissionDto.getResource())).findFirst();
        return groupInBase.map(AccessResource::new);
    }

    @Autowired
    public ConfigurationTablesSetConverter(ConfigurationTablesSetTableConverter configurationTablesSetTableConverter, ConfigurationTablesSetPermissionConverter configurationTablesSetPermissionConverter) {
        this.configurationTablesSetTableConverter = configurationTablesSetTableConverter;
        this.configurationTablesSetPermissionConverter = configurationTablesSetPermissionConverter;
    }
}

