/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.configurationtransfer.dto.alias.settings;

import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationColumnSettingDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationColumnSettingsConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationTableSettingDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationTableSettingConverter {
    private final ConfigurationColumnSettingsConverter configurationColumnSettingsConverter;

    public List<ConfigurationTableSettingDto> convertToDto(Map<String, TableSettings> tableSettings) {
        ArrayList<ConfigurationTableSettingDto> tableSettingsDtos = new ArrayList<ConfigurationTableSettingDto>();
        tableSettings.values().forEach(tableSetting -> tableSettingsDtos.add(this.convertToDto((TableSettings)tableSetting)));
        return tableSettingsDtos;
    }

    private ConfigurationTableSettingDto convertToDto(TableSettings tableSetting) {
        List<ConfigurationColumnSettingDto> columnsSettings = this.configurationColumnSettingsConverter.convertToDto(tableSetting.getColumnsSettings());
        return new ConfigurationTableSettingDto(tableSetting.getSchemaName(), tableSetting.getTableName(), tableSetting.getDisplayName(), columnsSettings);
    }

    public TableSettings convertToEntity(ConfigurationTableSettingDto tableSettingDto) {
        TableSettings tableSettings = new TableSettings(tableSettingDto.getSchemaName(), tableSettingDto.getTableName());
        if (StringUtils.isNotBlank((CharSequence)tableSettingDto.getDisplayName())) {
            tableSettings.setDisplayName(tableSettingDto.getDisplayName());
        }
        for (ConfigurationColumnSettingDto columnSettingDto : tableSettingDto.getColumnsSettings().getList()) {
            ColumnSettings columnSettings = this.configurationColumnSettingsConverter.convertToEntity(columnSettingDto);
            tableSettings.addColumnSettings(columnSettings);
        }
        return tableSettings;
    }

    @Autowired
    public ConfigurationTableSettingConverter(ConfigurationColumnSettingsConverter configurationColumnSettingsConverter) {
        this.configurationColumnSettingsConverter = configurationColumnSettingsConverter;
    }
}

