/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.settings;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.util.persistence.Json;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import java.util.Collections;
import java.util.Map;

@Embeddable
@AttributeOverride(name="serialized", column=@Column(name="settings"))
public class Settings
extends Json<Settings> {
    @Transient
    private Map<String, TableSettings> tablesSettings = Maps.newHashMap();

    @Override
    protected void apply(Settings serialized) {
        this.tablesSettings = serialized.tablesSettings;
    }

    public TableSettings getTableSettings(String schema, String table) {
        TableSettings settings = this.tablesSettings.get(this.prepareKey(schema, table));
        if (settings == null) {
            settings = new TableSettings(schema, table);
            this.addTablesSettings(settings);
        }
        return settings;
    }

    public Map<String, TableSettings> getTablesSettings() {
        return Collections.unmodifiableMap(this.tablesSettings);
    }

    public void addTablesSettings(TableSettings settings) {
        this.tablesSettings.put(this.prepareKey(settings.getSchemaName(), settings.getTableName()), settings);
    }

    private String prepareKey(String schema, String table) {
        return schema + "." + table;
    }
}

