/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data.util.importer;

import com.github.pjfanning.xlsx.StreamingReader;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.BasicDataType;
import com.suncode.pwfl.config.Environment;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImportHelper {
    private static final Logger log = LoggerFactory.getLogger(ImportHelper.class);
    private static final Path TEMP_POI_PATH = Paths.get(Environment.get((String)"plusworkflow.home"), "temp", "poi");

    public void processRecord(DatabaseSession session, Record record, boolean clear, int rowNum, long rowsInBase) {
        try {
            if (this.shouldUpdateRecord(clear, record, rowsInBase) && this.tryUpdateRecord(session, record, rowNum)) {
                return;
            }
            session.insert(record);
        }
        catch (Exception e) {
            log.error("Invalid data in row number {}", (Object)rowNum);
            throw e;
        }
    }

    private boolean shouldUpdateRecord(boolean clear, Record record, long rowsInBase) {
        return !clear && record.hasId() && rowsInBase > 0L;
    }

    private boolean tryUpdateRecord(DatabaseSession session, Record record, int rowNum) {
        ColumnSchema[] primaryKeyColumns = record.getTable().getPrimaryKeyColumns();
        if (!this.recordHasPkValue(primaryKeyColumns, record)) {
            if (this.recordHasAutoIncrementColumn(primaryKeyColumns)) {
                return false;
            }
            Translator translator = Translators.get(ImportHelper.class);
            throw new IllegalStateException(translator.getMessage("dbex.data.import.null.exception"));
        }
        return session.update(record);
    }

    private boolean recordHasAutoIncrementColumn(ColumnSchema[] pkColumns) {
        return Arrays.stream(pkColumns).anyMatch(col -> col.isAutoIncrement());
    }

    public Record createRecord(Database database, Table table, XSSFFormulaEvaluator evaluator, String[] columnNames, Row row, TableSchema tableSchema) {
        Record record = new Record(tableSchema.getSchema(), tableSchema.getName(), database);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            if (columnName == null || !table.getTableSchema().hasColumn(columnName)) continue;
            Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            ColumnSchema columnSchema = table.getTableSchema().getColumn(columnName);
            BasicDataType basicType = BasicDataType.of(columnSchema.getType());
            if (evaluator != null) {
                evaluator.evaluateInCell(cell);
            }
            Object value = this.readCellValue(cell, basicType);
            record.set(columnName, value);
        }
        return record;
    }

    public Record createRecord(Database database, Table table, String[] columnNames, Row row, TableSchema tableSchema) {
        return this.createRecord(database, table, null, columnNames, row, tableSchema);
    }

    private Object readCellValue(Cell cell, BasicDataType basicType) {
        Object value = null;
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                if (basicType == BasicDataType.DATE || basicType == BasicDataType.DATETIME || basicType == BasicDataType.TIME) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
            }
        }
        return value;
    }

    public OPCPackage getOpcPackage(File tempPoiFile) throws IOException {
        OPCPackage opcPackage;
        try {
            opcPackage = OPCPackage.open((File)tempPoiFile, (PackageAccess)PackageAccess.READ);
        }
        catch (InvalidFormatException e1) {
            tempPoiFile.delete();
            throw new IOException(e1);
        }
        catch (Exception e) {
            tempPoiFile.delete();
            throw e;
        }
        return opcPackage;
    }

    public File getTempPoiFile() throws IOException {
        Path tempPoiDirectoryPath = Files.createDirectories(TEMP_POI_PATH, new FileAttribute[0]);
        Path tempPoiFilePath = Files.createTempFile(tempPoiDirectoryPath, null, null, new FileAttribute[0]);
        return tempPoiFilePath.toFile();
    }

    public List<String> readColumns(InputStream inputStream) throws IOException {
        File tempPoiFile = this.getTempPoiFile();
        tempPoiFile.deleteOnExit();
        try (FileOutputStream tempOutputStream = new FileOutputStream(tempPoiFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)tempOutputStream);
        }
        catch (Exception e) {
            tempPoiFile.delete();
            throw e;
        }
        try {
            ArrayList<String> arrayList;
            block18: {
                Workbook workbook = StreamingReader.builder().rowCacheSize(1).open(tempPoiFile);
                try {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    Sheet sheet = workbook.getSheetAt(0);
                    Iterator rowIterator = sheet.iterator();
                    Row headerRow = (Row)rowIterator.next();
                    for (Cell cell : headerRow) {
                        columnNames.add(cell.getStringCellValue());
                    }
                    arrayList = columnNames;
                    if (workbook == null) break block18;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return arrayList;
        }
        finally {
            tempPoiFile.delete();
        }
    }

    public SheetData readSheetData(InputStream inputStream) throws IOException {
        File tempPoiFile = this.getTempPoiFile();
        tempPoiFile.deleteOnExit();
        try (FileOutputStream tempOutputStream = new FileOutputStream(tempPoiFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)tempOutputStream);
        }
        catch (Exception e) {
            tempPoiFile.delete();
            throw e;
        }
        try {
            SheetData sheetData;
            block19: {
                Workbook workbook = StreamingReader.builder().rowCacheSize(4000).open(tempPoiFile);
                try {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    Sheet sheet = workbook.getSheetAt(0);
                    Iterator rowIterator = sheet.iterator();
                    Row headerRow = (Row)rowIterator.next();
                    long rowCount = 1L;
                    for (Cell cell : headerRow) {
                        columnNames.add(cell.getStringCellValue());
                    }
                    while (rowIterator.hasNext()) {
                        ++rowCount;
                        rowIterator.next();
                    }
                    sheetData = new SheetData(columnNames, rowCount);
                    if (workbook == null) break block19;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return sheetData;
        }
        finally {
            tempPoiFile.delete();
        }
    }

    public boolean recordHasPkValue(ColumnSchema[] pkColumns, Record record) {
        for (ColumnSchema schema : pkColumns) {
            if (record.get(schema.getName()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.toString().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static class SheetData {
        private final List<String> columnNames;
        private final long rowCount;

        public SheetData(List<String> columnNames, long rowCount) {
            this.columnNames = columnNames;
            this.rowCount = rowCount;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public long getRowCount() {
            return this.rowCount;
        }
    }
}

