/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data.util.exporter;

import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.type.BasicDataType;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.DateFormatConverter;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.NumberUtils;

@Component
public class ExcelExporter {
    public SXSSFWorkbook exportRecords(Table table, List<Record> records) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(table.getName());
        sheet.trackAllColumnsForAutoSizing();
        int columnsCount = this.addHeaderRow(sheet, table);
        String dateFormat = DateFormatConverter.convert((Locale)LocaleContextHolder.getLocale(), (String)"yyyy-MM-dd");
        String timeFormat = DateFormatConverter.convert((Locale)LocaleContextHolder.getLocale(), (String)"hh:mm:ss");
        String dateTimeFormat = DateFormatConverter.convert((Locale)LocaleContextHolder.getLocale(), (String)"yyyy-MM-dd hh:mm:ss");
        CellStyle dateStyle = workbook.createCellStyle();
        dateStyle.setDataFormat(workbook.createDataFormat().getFormat(dateFormat));
        CellStyle timeStyle = workbook.createCellStyle();
        timeStyle.setDataFormat(workbook.createDataFormat().getFormat(timeFormat));
        CellStyle dateTimeStyle = workbook.createCellStyle();
        dateTimeStyle.setDataFormat(workbook.createDataFormat().getFormat(dateTimeFormat));
        int rowNr = 1;
        for (Record record : records) {
            SXSSFRow row = sheet.createRow(rowNr++);
            int colNr = 0;
            for (ColumnSchema column : table.getTableSchema().getColumns()) {
                SXSSFCell cell = row.createCell(colNr++);
                Object value = record.get(column.getName());
                if (value == null) continue;
                BasicDataType basicDataType = BasicDataType.of(column.getType());
                if (basicDataType != null) {
                    switch (basicDataType) {
                        case STRING: {
                            cell.setCellValue(value.toString());
                            break;
                        }
                        case INTEGER: {
                            cell.setCellValue((double)((Long)NumberUtils.convertNumberToTargetClass((Number)((Number)value), Long.class)).longValue());
                            break;
                        }
                        case FLOAT: {
                            cell.setCellValue(((Double)NumberUtils.convertNumberToTargetClass((Number)((Number)value), Double.class)).doubleValue());
                            break;
                        }
                        case BOOLEAN: {
                            cell.setCellValue(((Boolean)value).booleanValue());
                            break;
                        }
                        case DATE: {
                            cell.setCellValue((Date)value);
                            cell.setCellStyle(dateStyle);
                            break;
                        }
                        case TIME: {
                            cell.setCellValue((Date)value);
                            cell.setCellStyle(timeStyle);
                            break;
                        }
                        case DATETIME: {
                            cell.setCellValue((Date)value);
                            cell.setCellStyle(dateTimeStyle);
                            break;
                        }
                    }
                    continue;
                }
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Double)NumberUtils.convertNumberToTargetClass((Number)((Number)value), Double.class)).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    cell.setCellStyle(dateTimeStyle);
                    continue;
                }
                cell.setCellValue(value.toString());
            }
        }
        for (int i = 0; i < columnsCount; ++i) {
            sheet.autoSizeColumn(i);
        }
        return workbook;
    }

    private int addHeaderRow(SXSSFSheet sheet, Table table) {
        int colNr = 0;
        SXSSFRow headerRow = sheet.createRow(0);
        for (ColumnSchema column : table.getTableSchema().getColumns()) {
            SXSSFCell cell = headerRow.createCell(colNr++);
            cell.setCellValue(column.getName());
        }
        return colNr;
    }
}

