/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Conditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Filter {
    private String column;
    private Map<String, Object> rule;

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public Map<String, Object> getRule() {
        return this.rule;
    }

    public void setRule(Map<String, Object> rule) {
        this.rule = rule;
    }

    public static Condition[] conditions(Filter ... filters) {
        return Filter.conditions(Arrays.asList(filters));
    }

    public static Condition[] conditions(List<Filter> filters) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Filter filter : filters) {
            conditions.addAll(Filter.getConditions(filter.getRule(), filter));
        }
        return (Condition[])Iterables.toArray(conditions, Condition.class);
    }

    private static List<Condition> getConditions(Map<String, Object> rule, Filter filter) {
        ArrayList conditions = Lists.newArrayList();
        for (String cond : rule.keySet()) {
            Condition condition = Filter.getCondition(cond, rule.get(cond), filter);
            if (condition == null) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    private static Condition getCondition(String cond, Object value, Filter filter) {
        if ("not".equals(cond)) {
            Map notRule = (Map)value;
            List<Condition> conditions = Filter.getConditions(notRule, filter);
            Condition condition = Conditions.and(conditions.toArray(new Condition[conditions.size()]));
            return Conditions.not(condition);
        }
        if ("isNull".equals(cond)) {
            return Conditions.isNull(filter.getColumn());
        }
        if (value != null) {
            if ("eqOrIsNull".equals(cond)) {
                return Conditions.eqOrIsNull(filter.getColumn(), value);
            }
            if ("eq".equals(cond)) {
                return Conditions.eq(filter.getColumn(), value);
            }
            if ("gt".equals(cond)) {
                return Conditions.gt(filter.getColumn(), value);
            }
            if ("ge".equals(cond)) {
                return Conditions.ge(filter.getColumn(), value);
            }
            if ("le".equals(cond)) {
                return Conditions.le(filter.getColumn(), value);
            }
            if ("lt".equals(cond)) {
                return Conditions.lt(filter.getColumn(), value);
            }
            if ("like".equals(cond)) {
                return Conditions.like(filter.getColumn(), (String)value);
            }
            if ("ilike".equals(cond)) {
                return Conditions.ilike(filter.getColumn(), (String)value);
            }
            if ("withinMinutes".equals(cond)) {
                return Conditions.withinMinutes(filter.getColumn(), (Integer)value);
            }
            if ("withinHours".equals(cond)) {
                return Conditions.withinHours(filter.getColumn(), (Integer)value);
            }
            if ("withinDays".equals(cond)) {
                return Conditions.withinDays(filter.getColumn(), (Integer)value);
            }
            if ("withinWeeks".equals(cond)) {
                return Conditions.withinWeeks(filter.getColumn(), (Integer)value);
            }
            if ("withinMonths".equals(cond)) {
                return Conditions.withinMonths(filter.getColumn(), (Integer)value);
            }
            if ("withinYears".equals(cond)) {
                return Conditions.withinYears(filter.getColumn(), (Integer)value);
            }
        }
        return null;
    }
}

