import Assert from '../../assert/Assert';

export const SHOW_PROCESS_DETAILS = 'showProcessDetails';

class ShowProcessDetailsActionResolver {
  getAction(rawAction) {
    let mapping = rawAction.mapping;
    Assert.hasText(mapping.processId, 'ProcessId for ShowProcessDetailsAction cannot be empty');

    return {
      type: rawAction.type,
      mapping: {
        processId: mapping.processId,
      },
    };
  }

  validate(action, view) {
    let processIdMapping = action.mapping.processId;
    let processIdOutputId = view.outputs.find(output => output.id == processIdMapping);
    Assert.notNull(processIdOutputId, 'There is no output with id ' + processIdMapping);
  }
}

export default new ShowProcessDetailsActionResolver();
