import { STYLE_TYPE } from '../../util/types/styleTypes';
import ConditionResolver from './ConditionResolver';

class StyleResolver {
  getStyles(output) {
    if (!output.styles) {
      return [];
    }

    return output.styles.filter(style => this.isStyleValid(style));
  }

  isStyleValid(style) {
    if (!style.type) {
      console.warn('Invalid style definition. Missing type property.');
      return false;
    }

    if (!STYLE_TYPE[style.type.toString().toUpperCase()]) {
      console.warn(`Invalid style definition. Invalid type property: ${style.type}`);
      return false;
    }

    try {
      ConditionResolver.getCondition(style.condition);
    } catch (e) {
      console.warn(`Invalid style definition. Error thrown on condition validation: ${e}`);
      return false;
    }

    return true;
  }
}

export default new StyleResolver();
