import Assert from '../assert/Assert';
import { OPERATOR } from '../../util/types/operatorTypes';

class ConditionResolver {
  getCondition(condition) {
    if (!condition) {
      return null;
    }

    Assert.notNull(condition.columnId, `"columnId" cannot be empty in condition`);
    Assert.notNull(condition.operator, `"operator" cannot be empty in condition`);

    if (!Object.values(OPERATOR).some(validOperator => validOperator.toLowerCase() === condition.operator.toLowerCase())) {
      throw `Invalid operator: ${condition.operator}. Valid values: ${Object.values(OPERATOR).join(', ')}`;
    }

    const isValueRequired = !(
      OPERATOR.IS_EMPTY.toLowerCase() === condition.operator.toLowerCase() ||
      OPERATOR.IS_NOT_EMPTY.toLowerCase() === condition.operator.toLowerCase()
    );
    if (isValueRequired && condition.value === null && condition.columnValue === null) {
      throw `"value" or "columnValue" must not be empty in condition`;
    }

    if (condition.group) {
      condition.group.forEach(groupCondition => this.getCondition(groupCondition));
    }

    return condition;
  }
}

export default new ConditionResolver();
