import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';

class VariableService {
  async getSearchVariableDefinitions(processDefinitionId) {
    return (await axios.get(absolutePath(`api/processes/variables/${processDefinitionId}`))).data;
  }

  async getExtendedSearchVariableDefinitions(processDefinitionId) {
    return (await axios.get(absolutePath(`api/processes/variables/extended/${processDefinitionId}`))).data;
  }

  async fetchAdvanceSearchResultsValues(processId, columnIds) {
    try {
      return (await axios.post(absolutePath(`api/processes/variables/${processId}/values`), columnIds)).data;
    } catch (error) {
      return error.response.data;
    }
  }
}

export default new VariableService();
