import '@babel/polyfill';
import 'core-js/features/array/flat-map';

import Vue from 'vue';
import App from './view/DefaultView.vue';
import router from './router/router';
import vSelect from 'vue-select';
import { createPinia, PiniaVuePlugin } from 'pinia';

import '../scss/menu.scss';
import { createI18n } from '../util/translationUtils';

import 'vue-select/dist/vue-select.css';

Vue.component('v-select', vSelect);
Vue.use(PiniaVuePlugin);

new Vue({
  render: h => h(App),
  router,
  i18n: createI18n(),
  pinia: createPinia(),
}).$mount('#data-viewer-menu');
