/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.util;

import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.util.SpringContext;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtils {
    private static final Logger log = LoggerFactory.getLogger(MailUtils.class);

    public static void send(String recipients, String subject, String reportFilename, String content, byte[] byteArray) throws MessagingException, UnsupportedEncodingException {
        EmailService emailService = (EmailService)SpringContext.getBean(EmailService.class);
        EmailConfigurationService emailConfigurationService = (EmailConfigurationService)SpringContext.getBean(EmailConfigurationService.class);
        EmailConfiguration emailConfiguration = emailConfigurationService.getDefaultConfiguration();
        Session session = emailService.getSession(emailConfiguration);
        MimeMessage message = new MimeMessage(session);
        message.addRecipients(Message.RecipientType.BCC, recipients);
        message.setSubject(subject);
        message.setFrom((Address)MailUtils.getInternetAddress(emailConfiguration.getEmail(), emailConfiguration.getSourceAddress()));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)content, "text/html; charset=utf-8");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        String mimeType = "application/vnd.ms-excel ";
        messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(byteArray, mimeType)));
        messageBodyPart.setFileName(MimeUtility.encodeText((String)reportFilename, (String)"UTF-8", null));
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        emailService.send(message);
        log.debug("An email with report generated from scheduled task has been sent to the addresses: " + recipients);
    }

    private static InternetAddress getInternetAddress(String email, String sourceAddress) throws AddressException {
        if (StringUtils.isBlank((String)sourceAddress)) {
            return new InternetAddress(email);
        }
        try {
            return new InternetAddress(email, sourceAddress);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            return new InternetAddress(email);
        }
    }
}

