/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.transfer.ConfigurationMenuDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
class ConfigurationMenuConverter {
    private final ObjectMapper objectMapper = new ObjectMapper();

    List<ConfigurationMenuDto> convertToDto(List<Menu> menus) throws JsonProcessingException {
        ArrayList<ConfigurationMenuDto> list = new ArrayList<ConfigurationMenuDto>();
        for (Menu menu : menus) {
            ConfigurationMenuDto configurationMenuDto = new ConfigurationMenuDto(menu.getName(), this.objectMapper.writeValueAsString((Object)menu));
            list.add(configurationMenuDto);
        }
        return list;
    }

    List<Menu> convertToMenu(List<ConfigurationMenuDto> configurationMenuDtos) throws JsonProcessingException {
        ArrayList<Menu> list = new ArrayList<Menu>();
        for (ConfigurationMenuDto configurationMenuDto : configurationMenuDtos) {
            Menu menu = (Menu)this.objectMapper.readValue(configurationMenuDto.getConfiguration(), Menu.class);
            list.add(menu);
        }
        return list;
    }
}

