/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.persmission;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.plugin.dataviewer.service.persmission.MenuUserPair;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class PermissionCache {
    private static final Long EXPIRATION_TIME_SEC = 60L;
    private Cache<MenuUserPair, Boolean> permanentCache = CacheBuilder.newBuilder().build();
    private Cache<MenuUserPair, Boolean> expirationCache = CacheBuilder.newBuilder().expireAfterWrite(EXPIRATION_TIME_SEC.longValue(), TimeUnit.SECONDS).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Boolean> get(MenuUserPair key) {
        PermissionCache permissionCache = this;
        synchronized (permissionCache) {
            Boolean permanentValue = (Boolean)this.permanentCache.getIfPresent((Object)key);
            if (permanentValue != null) {
                return Optional.of(permanentValue);
            }
            return Optional.ofNullable((Boolean)this.expirationCache.getIfPresent((Object)key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(MenuUserPair key, Boolean value) {
        PermissionCache permissionCache = this;
        synchronized (permissionCache) {
            this.permanentCache.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTemporarily(MenuUserPair key, Boolean value) {
        PermissionCache permissionCache = this;
        synchronized (permissionCache) {
            this.expirationCache.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        PermissionCache permissionCache = this;
        synchronized (permissionCache) {
            this.permanentCache.invalidateAll();
            this.expirationCache.invalidateAll();
        }
    }
}

