/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.datasupplier;

import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplier;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierNotExistsException;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSupplier
implements DataSupplier {
    private static final Logger log = LoggerFactory.getLogger(DataSourceSupplier.class);
    private String id;
    private DataSourceService dataSourceService;

    @Override
    public CountedResult<Map<String, Object>> getData(Map<String, String> parameters, Pagination pagination) throws DataSupplierNotExistsException {
        DataSourceInstance dataSource = this.dataSourceService.getDataSource(this.id);
        this.ensureDataSource(dataSource);
        return dataSource.execute(parameters, pagination);
    }

    private void ensureDataSource(DataSourceInstance dataSource) throws DataSupplierNotExistsException {
        if (dataSource == null) {
            throw new DataSupplierNotExistsException(this.id);
        }
    }

    @Override
    public Map<String, String> getAliasTypes() {
        DataSourceInstance dataSource = this.dataSourceService.getDataSource(this.id);
        if (dataSource == null) {
            throw new IllegalArgumentException("Data supplier with id " + this.id + " does not exist");
        }
        return dataSource.getInputParameters().stream().map(dataSourceParameter -> new AbstractMap.SimpleEntry<String, String>(dataSourceParameter.getId(), dataSourceParameter.getType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public DataSourceSupplier(String id, DataSourceService dataSourceService) {
        this.id = id;
        this.dataSourceService = dataSourceService;
    }
}

