/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.comment;

import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.NonNull;

@Entity
@Table(name="dv_comment_key", uniqueConstraints={@UniqueConstraint(columnNames={"menuId", "viewId", "supplierType", "supplierId", "row_id"}, name="dv_comment_key_uk")})
@SequenceGenerator(name="dv_comment_key_seq", sequenceName="dv_comment_key_id")
@Embeddable
public class CommentKey {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="dv_comment_key_seq")
    private Long id;
    @NonNull
    private String menuId;
    @NonNull
    private String viewId;
    @Enumerated
    @NonNull
    private DataSupplierFactory.DataSupplierType supplierType;
    @NonNull
    private String supplierId;
    @Column(name="row_id")
    @NonNull
    private String rowId;

    private CommentKey() {
    }

    private CommentKey(String menuId, String viewId, DataSupplierFactory.DataSupplierType supplierType, String supplierId) {
        this.menuId = menuId;
        this.viewId = viewId;
        this.supplierType = supplierType;
        this.supplierId = supplierId;
    }

    protected static CommentKey viewExample(String menuId, String viewId, DataSupplierFactory.DataSupplierType supplierType, String supplierId) {
        return new CommentKey(menuId, viewId, supplierType, supplierId);
    }

    public Long getId() {
        return this.id;
    }

    @NonNull
    public String getMenuId() {
        return this.menuId;
    }

    @NonNull
    public String getViewId() {
        return this.viewId;
    }

    @NonNull
    public DataSupplierFactory.DataSupplierType getSupplierType() {
        return this.supplierType;
    }

    @NonNull
    public String getSupplierId() {
        return this.supplierId;
    }

    @NonNull
    public String getRowId() {
        return this.rowId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMenuId(@NonNull String menuId) {
        if (menuId == null) {
            throw new NullPointerException("menuId is marked non-null but is null");
        }
        this.menuId = menuId;
    }

    public void setViewId(@NonNull String viewId) {
        if (viewId == null) {
            throw new NullPointerException("viewId is marked non-null but is null");
        }
        this.viewId = viewId;
    }

    public void setSupplierType(@NonNull DataSupplierFactory.DataSupplierType supplierType) {
        if (supplierType == null) {
            throw new NullPointerException("supplierType is marked non-null but is null");
        }
        this.supplierType = supplierType;
    }

    public void setSupplierId(@NonNull String supplierId) {
        if (supplierId == null) {
            throw new NullPointerException("supplierId is marked non-null but is null");
        }
        this.supplierId = supplierId;
    }

    public void setRowId(@NonNull String rowId) {
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        this.rowId = rowId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentKey)) {
            return false;
        }
        CommentKey other = (CommentKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$menuId = this.getMenuId();
        String other$menuId = other.getMenuId();
        if (this$menuId == null ? other$menuId != null : !this$menuId.equals(other$menuId)) {
            return false;
        }
        String this$viewId = this.getViewId();
        String other$viewId = other.getViewId();
        if (this$viewId == null ? other$viewId != null : !this$viewId.equals(other$viewId)) {
            return false;
        }
        DataSupplierFactory.DataSupplierType this$supplierType = this.getSupplierType();
        DataSupplierFactory.DataSupplierType other$supplierType = other.getSupplierType();
        if (this$supplierType == null ? other$supplierType != null : !((Object)((Object)this$supplierType)).equals((Object)other$supplierType)) {
            return false;
        }
        String this$supplierId = this.getSupplierId();
        String other$supplierId = other.getSupplierId();
        if (this$supplierId == null ? other$supplierId != null : !this$supplierId.equals(other$supplierId)) {
            return false;
        }
        String this$rowId = this.getRowId();
        String other$rowId = other.getRowId();
        return !(this$rowId == null ? other$rowId != null : !this$rowId.equals(other$rowId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommentKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $menuId = this.getMenuId();
        result = result * 59 + ($menuId == null ? 43 : $menuId.hashCode());
        String $viewId = this.getViewId();
        result = result * 59 + ($viewId == null ? 43 : $viewId.hashCode());
        DataSupplierFactory.DataSupplierType $supplierType = this.getSupplierType();
        result = result * 59 + ($supplierType == null ? 43 : ((Object)((Object)$supplierType)).hashCode());
        String $supplierId = this.getSupplierId();
        result = result * 59 + ($supplierId == null ? 43 : $supplierId.hashCode());
        String $rowId = this.getRowId();
        result = result * 59 + ($rowId == null ? 43 : $rowId.hashCode());
        return result;
    }

    public String toString() {
        return "CommentKey(id=" + this.getId() + ", menuId=" + this.getMenuId() + ", viewId=" + this.getViewId() + ", supplierType=" + String.valueOf((Object)this.getSupplierType()) + ", supplierId=" + this.getSupplierId() + ", rowId=" + this.getRowId() + ")";
    }

    public CommentKey(@NonNull String menuId, @NonNull String viewId, @NonNull DataSupplierFactory.DataSupplierType supplierType, @NonNull String supplierId, @NonNull String rowId) {
        if (menuId == null) {
            throw new NullPointerException("menuId is marked non-null but is null");
        }
        if (viewId == null) {
            throw new NullPointerException("viewId is marked non-null but is null");
        }
        if (supplierType == null) {
            throw new NullPointerException("supplierType is marked non-null but is null");
        }
        if (supplierId == null) {
            throw new NullPointerException("supplierId is marked non-null but is null");
        }
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        this.menuId = menuId;
        this.viewId = viewId;
        this.supplierType = supplierType;
        this.supplierId = supplierId;
        this.rowId = rowId;
    }
}

