import Assert from '../../assert/Assert';

export const SHOW_VIEW = 'showView';

class ShowViewActionResolver {
  getAction(rawAction) {
    Assert.hasText(rawAction.viewId, 'View id for ShowViewAction cannot be empty');

    return {
      type: rawAction.type,
      viewId: rawAction.viewId,
      mappings: this.getMappings(rawAction),
    };
  }

  getMappings(action) {
    return action.mappings.map(mapping => {
      Assert.hasText(mapping.outputId + mapping.value, 'Value or outputId for ShowViewAction cannot be empty');
      Assert.hasText(mapping.inputId, 'InputId for ShowViewAction cannot be empty');

      return {
        value: mapping.value,
        outputId: mapping.outputId,
        inputId: mapping.inputId,
      };
    });
  }

  validate(action, view, views) {
    let viewId = action.viewId;
    Assert.isTrue(viewId != view.id, 'Action viewId has to bee different than current view id');

    let actionView = views.find(item => viewId == item.id);
    Assert.notNull(actionView, 'There is no view with id ' + viewId);

    action.mappings.forEach(mapping => {
      let inputId = mapping.inputId;
      let mappingInput = actionView.inputs.find(input => input.id == inputId);
      Assert.notNull(mappingInput, 'In view ' + actionView.id + ' there is no input with id ' + inputId + ' in view action');

      if (!mapping.value) {
        let outputId = mapping.outputId;
        let mappingOutput = view.outputs.find(output => output.id == outputId);
        Assert.notNull(
          mappingOutput,
          'In view ' + view.id + ' there is no ' + (mapping.value ? '' : ' value or ') + 'output with id ' + outputId + ' in view action',
        );
      }
    });
  }
}

export default new ShowViewActionResolver();
