import Assert from '../assert/Assert';
import SourceResolver from './SourceResolver';

class SummaryResolver {
  getSummary(view) {
    if (view.summary) {
      Assert.notNull(view.summary.source, 'Source of the summary cannot be empty');

      let summary = {
        source: SourceResolver.getSource(view.summary),
        inputMappings: this.getInputMappings(view.summary),
        outputMappings: this.getOutputMappings(view.summary),
        loadOnce: !!view.summary.loadOnce,
      };

      this.validateInputIds(view, summary);
      this.validateOutputIds(view, summary);
      return summary;
    } else {
      return null;
    }
  }

  getInputMappings(summary) {
    let mappings = summary.inputMappings;
    if (mappings) {
      return mappings.map(mapping => {
        Assert.hasText(mapping.inputId, 'Input id for input mapping cannot be empty');
        Assert.hasText(mapping.alias, 'Alias for input mapping cannot be empty');

        return {
          inputId: mapping.inputId,
          alias: mapping.alias,
        };
      });
    } else {
      return [];
    }
  }

  validateInputIds(view, summary) {
    summary.inputMappings.forEach(mapping => {
      let input = view.inputs.find(item => item.id == mapping.inputId);
      Assert.notNull(input, 'There is not input with id ' + mapping.inputId);
    });
  }

  getOutputMappings(summary) {
    let mappings = summary.outputMappings;
    Assert.notEmpty(mappings, 'Output mappings for the summary cannot be empty');

    return mappings.map(mapping => {
      Assert.hasText(mapping.outputId, 'Output id for output mapping cannot be empty');
      Assert.hasText(mapping.alias, 'Alias for output mapping cannot be empty');

      return {
        outputId: mapping.outputId,
        alias: mapping.alias,
      };
    });
  }

  validateOutputIds(view, summary) {
    summary.outputMappings.forEach(mapping => {
      let output = view.outputs.find(item => item.id == mapping.outputId);
      Assert.notNull(output, 'There is not output with id ' + mapping.outputId);
    });
  }
}

export default new SummaryResolver();
