/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.format.DoubleFormat;
import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.plugin.dataviewer.configuration.format.IntegerFormat;
import com.suncode.plugin.dataviewer.configuration.format.TimestampFormat;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierService;
import com.suncode.plugin.dataviewer.service.export.ExportRequest;
import com.suncode.plugin.dataviewer.service.export.ExportService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.dataviewer.web.api.util.ConfigurationHelper;
import com.suncode.plugin.dataviewer.web.dto.CellValueDto;
import com.suncode.plugin.dataviewer.web.dto.DataResultDto;
import com.suncode.plugin.dataviewer.web.dto.SorterDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"api/data"})
public class ExportController {
    @Autowired
    private ExportService exportService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private DataSupplierService dataSupplierService;
    private ObjectMapper mapper = new ObjectMapper();

    @RequestMapping(value={"{viewId}/excel"})
    public HttpEntity<byte[]> excel(@PathVariable String viewId, @RequestParam(required=false) String parameters, SorterDto sorter) throws IOException {
        Menu menu = this.configurationHelper.findMenuByViewId(viewId);
        this.permissionService.validatePermission(menu.getId());
        View view = this.configurationHelper.findView(viewId, menu);
        Map params = (Map)this.mapper.readValue(parameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        DataResultDto dataResult = this.dataSupplierService.getData(menu.getId(), view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)0, (Integer)Integer.MAX_VALUE), Arrays.asList(IntegerFormat.class, DoubleFormat.class, TimestampFormat.class));
        ArrayList<Map<String, Object>> rowsToExport = new ArrayList<Map<String, Object>>();
        for (Map valueMap : dataResult.getData()) {
            HashMap<String, Object> rowToExport = new HashMap<String, Object>();
            for (Map.Entry entry : valueMap.entrySet()) {
                rowToExport.put((String)entry.getKey(), this.sanitizeValue(((CellValueDto)entry.getValue()).getValue()));
            }
            rowsToExport.add(rowToExport);
        }
        CountedResult<Map<String, Object>> summaryResult = this.getSummaryData(sorter, view, params, Arrays.asList(IntegerFormat.class, DoubleFormat.class, TimestampFormat.class));
        ExportRequest exportRequest = new ExportRequest(view, rowsToExport, dataResult.getComments(), summaryResult.getData());
        byte[] bytes = this.exportService.export(exportRequest);
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        header.set("Content-Disposition", "attachment; filename=export_" + view.getId() + ".xlsx");
        header.setContentLength((long)bytes.length);
        return new HttpEntity((Object)bytes, (MultiValueMap)header);
    }

    private Object sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        return Jsoup.clean((String)((String)value), (Safelist)Safelist.simpleText());
    }

    private CountedResult<Map<String, Object>> getSummaryData(SorterDto sorter, View view, Map<String, String> params, List<Class<? extends Format>> skipFormatting) {
        if (view.getSummary() != null) {
            return this.dataSupplierService.getSummaryData(view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)0, (Integer)Integer.MAX_VALUE), skipFormatting);
        }
        return new CountedResult(0L, new LinkedList());
    }
}

