/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.api;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.ViewNotExistsException;
import com.suncode.plugin.dataviewer.service.comment.Comment;
import com.suncode.plugin.dataviewer.service.comment.CommentKey;
import com.suncode.plugin.dataviewer.service.comment.CommentService;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionException;
import com.suncode.plugin.dataviewer.web.dto.CommentDto;
import com.suncode.plugin.dataviewer.web.dto.UserDto;
import com.suncode.pwfl.administration.user.UserContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"api/comments"})
public class CommentController {
    @Autowired
    private CommentService commentService;
    @Autowired
    private ConfigurationService configurationService;

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{viewId}/{rowId}"}, method={RequestMethod.POST})
    public void create(@RequestBody CommentDto commentDto, @PathVariable String viewId, @PathVariable String rowId) {
        Menu menu = this.findMenuByViewId(viewId);
        View view = this.findView(viewId, menu);
        CommentKey key = new CommentKey(menu.getId(), viewId, view.getSource().getType(), view.getSource().getId(), rowId);
        commentDto.setAuthor(UserDto.get(UserContext.current().getUser().getUserName()));
        Comment comment = commentDto.buildDomain();
        comment.setKey(key);
        comment.setAuthor(this.loggedUser());
        this.commentService.addComment(comment);
    }

    private Menu findMenuByViewId(String viewId) {
        return this.configurationService.getConfiguration().getMenus().stream().filter(menu -> menu.getViews().stream().anyMatch(view -> view.getId().equals(viewId))).findFirst().orElseThrow(() -> new ViewNotExistsException(viewId));
    }

    private View findView(String viewId, Menu menu) {
        return menu.getViews().stream().filter(viewItem -> viewItem.getId().equals(viewId)).findFirst().orElseThrow(() -> new ViewNotExistsException(viewId));
    }

    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{commentId}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable Long commentId) {
        Comment comment = this.commentService.getComment(commentId);
        if (!this.isLoggedUser(comment.getAuthor())) {
            throw new PermissionException();
        }
        this.commentService.deleteComment(comment);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.PUT})
    public void change(@RequestBody CommentDto commentDto) {
        if (!this.isLoggedUser(commentDto.getAuthor().getUserName())) {
            throw new PermissionException();
        }
        this.commentService.changeComment(commentDto.buildDomain());
    }

    private boolean isLoggedUser(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return false;
        }
        return userName.equals(this.loggedUser());
    }

    private String loggedUser() {
        if (UserContext.isActive()) {
            return UserContext.current().getUser().getUserName();
        }
        return null;
    }
}

