/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.configuration;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.configuration.View;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationTranslator {
    public void apply(Configuration configuration) {
        I18NCustom i18n = new I18NCustom(LocaleContextHolder.getLocale());
        configuration.getMenus().forEach(menu -> {
            String menuTranslation = i18n.getString(menu.getName());
            menu.setName(menuTranslation);
            menu.getViews().forEach(view -> this.apply(i18n, (View)view));
        });
    }

    private void apply(I18NCustom i18n, View view) {
        String viewTranslation = i18n.getString(view.getName());
        view.setName(viewTranslation);
        view.getInputs().forEach(input -> {
            String inputTranslation = i18n.getString(input.getName());
            input.setName(inputTranslation);
        });
        view.getOutputs().forEach(output -> {
            String outputTranslation = i18n.getString(output.getName());
            output.setName(outputTranslation);
        });
        view.getLinks().forEach(link -> {
            String linkTranslation = i18n.getString(link.getName());
            link.setName(linkTranslation);
        });
    }
}

