/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.configuration;

import com.suncode.plugin.dataviewer.service.persmission.PermissionCache;
import com.suncode.plugin.dataviewer.util.LazyCache;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationCache {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationCache.class);
    private LazyCache<String> configurationJsonCache = new LazyCache<String>(this::loadConfigurationString);
    @Autowired
    private PermissionCache permissionCache;
    @Autowired
    private PluginStore store;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadConfigurationString() {
        PluginStoreResource resource = this.store.read("config.json");
        if (resource == null) {
            log.warn("Configuration file does not exists");
            return "";
        }
        try (InputStream stream = resource.getInputStream();){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public String get() {
        return this.configurationJsonCache.get();
    }

    public void invalidate() {
        this.configurationJsonCache.invalidate();
        this.permissionCache.invalidate();
    }
}

