/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.scheduledTask;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.CoreTools;
import com.suncode.plugin.dataviewer.configuration.Input;
import com.suncode.plugin.dataviewer.configuration.InputType;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.Output;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.format.DoubleFormat;
import com.suncode.plugin.dataviewer.configuration.format.IntegerFormat;
import com.suncode.plugin.dataviewer.configuration.format.TimestampFormat;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierService;
import com.suncode.plugin.dataviewer.service.export.ExportRequest;
import com.suncode.plugin.dataviewer.service.export.ExportService;
import com.suncode.plugin.dataviewer.util.MailUtils;
import com.suncode.plugin.dataviewer.web.api.util.ConfigurationHelper;
import com.suncode.plugin.dataviewer.web.dto.CellValueDto;
import com.suncode.plugin.dataviewer.web.dto.DataResultDto;
import com.suncode.plugin.dataviewer.web.dto.InputFilterDto;
import com.suncode.plugin.dataviewer.web.dto.SorterDto;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@ScheduledTask
public class SendDataViewerReportTask {
    @Autowired
    private ExportService exportService;
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private DataSupplierService dataSupplierService;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("send-data-viewer-report")).name("data.viewer.scheduled.task.send.report.name")).description("data.viewer.scheduled.task.send.report.desc")).cancelable().parameter().id("mailTitle").name("data.viewer.scheduled.task.mail.title").description("data.viewer.scheduled.task.mail.title.description").type((Type)Types.STRING).create()).parameter().id("mailPath").name("data.viewer.scheduled.task.mail.path").description("data.viewer.scheduled.task.mail.path.description").type((Type)Types.STRING).create()).parameter().id("mailRecipients").name("data.viewer.scheduled.task.mail.recipients").description("data.viewer.scheduled.task.mail.recipients.description").type((Type)Types.STRING).create()).parameter().id("JSONParams").name("data.viewer.scheduled.task.json.params").description("data.viewer.scheduled.task.json.params.description").type((Type)Types.STRING).create()).parameter().id("viewId").name("data.viewer.scheduled.task.view.id").description("data.viewer.scheduled.task.view.id.description").type((Type)Types.STRING).create()).parameter().id("sortProperty").name("data.viewer.scheduled.task.filter.sort.property").description("data.viewer.scheduled.task.filter.sort.property.description").type((Type)Types.STRING).create()).parameter().id("sortDirection").name("data.viewer.scheduled.task.filter.sort.direction").description("data.viewer.scheduled.task.filter.sort.direction.description").type((Type)Types.STRING).create()).parameter().id("reportFilename").name("data.viewer.scheduled.task.report.filename").description("data.viewer.scheduled.task.report.filename.description").type((Type)Types.STRING).create()).parameter().id("reportFileExtension").name("data.viewer.scheduled.task.report.extension").description("data.viewer.scheduled.task.report.extension.description").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="mailTitle") String mailTitle, @Param(value="mailPath") String mailPath, @Param(value="mailRecipients") String mailRecipients, @Param(value="JSONParams") String JSONParams, @Param(value="viewId") String viewId, @Param(value="sortProperty") String sortProperty, @Param(value="sortDirection") String sortDirection, @Param(value="reportFilename") String reportFilename, @Param(value="reportFileExtension") String reportFileExtension) throws IOException, MessagingException, ParseException {
        Assert.isTrue((boolean)this.isSupportedExtension(reportFileExtension), (String)"Unsupported attachment extension");
        byte[] reportFile = this.generateReportFile(viewId, JSONParams, sortProperty, sortDirection);
        String template = new String(Files.readAllBytes(Paths.get(mailPath, new String[0])), StandardCharsets.UTF_8);
        MailUtils.send(mailRecipients, mailTitle, reportFilename + "." + reportFileExtension, template, reportFile);
    }

    private byte[] generateReportFile(String viewId, String parameters, String sortProperty, String sortDirection) throws IOException, ParseException {
        Menu menu = this.configurationHelper.findMenuByViewId(viewId);
        View view = this.configurationHelper.findView(viewId, menu);
        List inputFilters = (List)mapper.readValue(parameters, (TypeReference)new TypeReference<List<InputFilterDto>>(){});
        HashMap<String, String> params = new HashMap<String, String>();
        for (InputFilterDto filter : inputFilters) {
            params.put(filter.getInputId(), this.computeFilterValues(filter, view.getInputs()));
        }
        Output sortOutput = view.getOutputs().stream().filter(output -> output.getId().equals(sortProperty)).findFirst().orElseThrow(() -> new IllegalArgumentException("Incorrect sorting property"));
        Assert.isTrue((boolean)this.isProperSortDirection(sortDirection), (String)"The parameter specifying the sort direction is incorrect");
        SorterDto sorter = new SorterDto();
        sorter.setDirection(sortDirection);
        sorter.setProperty(sortOutput.getAlias());
        DataResultDto dataResult = this.dataSupplierService.getData(menu.getId(), view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)0, (Integer)Integer.MAX_VALUE), Arrays.asList(IntegerFormat.class, DoubleFormat.class, TimestampFormat.class));
        ArrayList<Map<String, Object>> rowsToExport = new ArrayList<Map<String, Object>>();
        for (Map valueMap : dataResult.getData()) {
            HashMap<String, Object> rowToExport = new HashMap<String, Object>();
            for (Map.Entry entry : valueMap.entrySet()) {
                rowToExport.put((String)entry.getKey(), this.sanitizeValue(((CellValueDto)entry.getValue()).getValue()));
            }
            rowsToExport.add(rowToExport);
        }
        CountedResult<Map<String, Object>> summaryResult = this.getSummaryData(sorter, view, params);
        ExportRequest exportRequest = new ExportRequest(view, rowsToExport, dataResult.getComments(), summaryResult.getData());
        return this.exportService.export(exportRequest);
    }

    private String computeFilterValues(InputFilterDto filter, List<Input> inputs) throws ParseException {
        Optional<Input> input = inputs.stream().filter(viewInput -> filter.getInputId().equals(viewInput.getId())).findAny();
        if (input.isPresent() && input.get().getType() == InputType.DATE) {
            String[] DATE_MARKER_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm"};
            Date date = DateUtils.parseDate((String)CoreTools.replaceDateMarker((String)filter.getInputValue()), (String[])DATE_MARKER_PATTERNS);
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            return new Long(Timestamp.valueOf(new LocalDateTime((Object)date).toString(formatter)).getTime()).toString();
        }
        return filter.getInputValue();
    }

    private boolean isProperSortDirection(String sortDirection) {
        try {
            SortDirection.valueOf((String)sortDirection);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Object sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        return Jsoup.clean((String)((String)value), (Safelist)Safelist.simpleText());
    }

    private CountedResult<Map<String, Object>> getSummaryData(SorterDto sorter, View view, Map<String, String> params) {
        if (view.getSummary() != null) {
            return this.dataSupplierService.getSummaryData(view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)0, (Integer)Integer.MAX_VALUE), Arrays.asList(IntegerFormat.class, DoubleFormat.class, TimestampFormat.class));
        }
        return new CountedResult(0L, new LinkedList());
    }

    private boolean isSupportedExtension(String reportType) {
        return reportType.equals("xlsx");
    }
}

