/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.configuration.format;

import com.suncode.plugin.dataviewer.configuration.format.Format;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampFormat
extends Format {
    private static final Logger log = LoggerFactory.getLogger(TimestampFormat.class);
    public static final String TYPE = "timestamp";
    private String dateFormat = "yyyy-MM-dd hh:mm:ss";

    @Override
    public String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString();
        }
        try {
            return new SimpleDateFormat(this.dateFormat).format((Timestamp)value);
        }
        catch (Exception e) {
            log.error("Could not format timestamp value {}", value);
            log.error(e.getMessage(), (Throwable)e);
            return value.toString();
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public String toString() {
        return "TimestampFormat(dateFormat=" + this.getDateFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampFormat)) {
            return false;
        }
        TimestampFormat other = (TimestampFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        return !(this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimestampFormat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        return result;
    }
}

