import moment from 'moment';

export function formatDate(date) {
  return formatDateByFormat(date, 'YYYY-MM-DD');
}

export function formatDateWithTime(date) {
  return formatDateByFormat(date, 'YYYY-MM-DD HH:mm:SS');
}

export function formatDateByFormat(date, stringFormat) {
  let dateObj = moment(date);
  return dateObj.format(stringFormat);
}

export function parseDateByFormat(stringDate, stringFormat) {
  return moment(stringDate, stringFormat);
}
