import Assert from '../../assert/Assert';

export const SHOW_ACTIVITY_DETAILS = 'showActivityDetails';

class ShowActivityDetailsActionResolver {
  getAction(rawAction) {
    let mapping = rawAction.mapping;
    Assert.hasText(mapping.processId, 'ProcessId for ShowActivityDetailsAction cannot be empty');
    Assert.hasText(mapping.activityId, 'InputId for ShowActivityDetailsAction cannot be empty');

    return {
      type: rawAction.type,
      mapping: {
        processId: mapping.processId,
        activityId: mapping.activityId,
      },
    };
  }

  validate(action, view) {
    let processIdMapping = action.mapping.processId;
    let processIdOutputId = view.outputs.find(output => output.id == processIdMapping);
    Assert.notNull(processIdOutputId, 'There is no output with id ' + processIdMapping);

    let activityIdMapping = action.mapping.activityId;
    let activityIdOutputId = view.outputs.find(output => output.id == activityIdMapping);
    Assert.notNull(activityIdOutputId, 'There is no output with id ' + activityIdMapping);
  }
}

export default new ShowActivityDetailsActionResolver();
