import Assert from '../assert/Assert';
import { DATASOURCE_TYPE } from '../../util/source/sourceTypes';

class SourceResolver {
  getSource(cmp) {
    const source = cmp.source;
    Assert.notNull(source, 'Source cannot be empty');

    const type = source.type;
    Assert.hasText(type, 'Source type cannot be empty');
    Assert.isTrue(type == DATASOURCE_TYPE, 'Source type is not DATASOURCE');
    Assert.hasText(source.id, 'Source id cannot be empty');

    const defaultOrder = source.defaultOrder;
    if (defaultOrder) {
      Assert.notNull(defaultOrder.orderProperty, 'Order property must be defined for source default order');
      Assert.notNull(defaultOrder.orderDirection, 'Order direction must be defined for source default order');
      Assert.isTrue(
        defaultOrder.orderDirection.toUpperCase() === 'ASC' || defaultOrder.orderDirection.toUpperCase() === 'DESC',
        'Allowed values for source default order: ASC, DESC',
      );
    }

    return {
      type,
      id: source.id,
      defaultOrder,
    };
  }
}

export default new SourceResolver();
