import Assert from '../assert/Assert';
import ViewResolver from './ViewResolver';

class MenuResolver {
  async getMenu(configuration, menuId) {
    const menusWithGivenId = await Promise.all(
      configuration.menus
        .filter(menu => menu.id === menuId)
        .map(async menu => {
          Assert.hasText(menu.id, 'Menu id cannot be empty');
          Assert.hasText(menu.name, 'Menu name cannot be empty');

          let views = await ViewResolver.getViews(menu);
          Assert.notEmpty(views, 'Views cannot be empty');

          return {
            id: menu.id,
            name: menu.name,
            views,
          };
        }),
    );

    Assert.isFalse(menusWithGivenId.length === 0, `There is no menu with id ${menuId}`);
    Assert.isFalse(menusWithGivenId.length > 1, `There is more than one menu with id ${menuId}`);

    const menu = menusWithGivenId[0];
    this.validateMenu(menu);

    return menu;
  }

  validateMenu(menu) {
    let allViewIds = menu.views.map(view => view.id);
    Assert.areUnique(allViewIds, 'View id must be unique among all menus');
  }
}

export default new MenuResolver();
