import Assert from '../assert/Assert';

class DocumentExtrasResolver {
  getDocumentExtras(view) {
    const documentExtras = {
      preview: false,
      attach: false,
      mapping: null,
    };

    if (!view.documentExtras) {
      return documentExtras;
    }

    const extras = view.documentExtras;

    documentExtras.preview = typeof extras.preview === 'boolean' ? extras.preview : false;
    documentExtras.attach = typeof extras.attach === 'boolean' ? extras.attach : false;

    if (documentExtras.preview || documentExtras.attach) {
      this.validateMapping(extras.mapping);
      documentExtras.mapping = {
        processId: extras.mapping.processId,
        activityId: extras.mapping.activityId,
      };
    }

    this.validateMappingOutputAliases(view, documentExtras.mapping);

    return documentExtras;
  }

  validateMapping(mapping) {
    Assert.notNull(mapping, 'Mapping object is missing');
    Assert.hasText(mapping.processId, '"processId" mapping cannot be empty');
    if (mapping.activityId) {
      Assert.hasText(mapping.activityId, '"activityId" mapping cannot be empty');
    }
  }

  validateMappingOutputAliases(view, mapping) {
    if (!mapping) {
      return;
    }

    const validateMapping = alias => {
      const output = view.outputs.find(item => item.alias === alias);
      Assert.notNull(output, `There is no output with alias ${alias}`);
    };
    validateMapping(mapping.processId);
    if (mapping.activityId) {
      validateMapping(mapping.activityId);
    }
  }
}

export default new DocumentExtrasResolver();
