import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class SummaryService {
  getSummary(view, start, limit, sortByAliasId, asc, parameters) {
    let direction = asc == true || asc == null ? 'ASC' : 'DESC';
    let property = sortByAliasId;

    return axios
      .get(absolutePath(API_URL + 'data/' + encodeURIComponent(view.id) + '/summary'), {
        params: { start, limit, direction, property, parameters },
      })
      .then(result => {
        let entity = result.data.entity;
        let data = entity.data;
        return data.map(row =>
          Object.keys(row).map(key => ({
            alias: key,
            value: row[key] + '',
          })),
        );
      });
  }
}

export default new SummaryService();
