import axios from 'axios';
import { API_URL } from '../../util/ajaxUtil';
import MenuResolver from '../resolver/MenuResolver';
import { copy } from '../../util/objectUtils';
import { absolutePath } from '../../util/urlUtils';

class ConfigurationService {
  constructor() {
    this.cached = null;
  }

  async getJson() {
    try {
      const response = await axios.get(absolutePath(API_URL + 'configuration/json'));
      const data = response.data;
      this.cached = copy(data);
      return data;
    } catch (err) {
      throw err;
    }
  }

  async get() {
    if (this.cached) {
      return this.cached;
    } else {
      try {
        const response = await axios.get(absolutePath(API_URL + 'configuration'));
        const data = response.data;
        this.cached = copy(data);
        return data;
      } catch (err) {
        throw err;
      }
    }
  }

  async getCurrentMenu() {
    const configuration = await this.get();
    return await MenuResolver.getMenu(configuration, this.getMenuId());
  }

  async save(configuration) {
    await axios.post(absolutePath(API_URL + 'configuration'), configuration);
    this.cached = null;
  }

  getMenuId() {
    return window.menuId;
  }
}

export default new ConfigurationService();
