/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.gadget;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dashboard.web.support.dto.PropertyDto;
import com.suncode.plugin.dataviewer.web.gadget.DataViewerGadget;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.favourites.util.SessionUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/gadget"})
public class GadgetController {
    private static final String GADGET_VIEW = "gadget";
    private static final String GADGET_ATTRIBUTE_NAME = "gadget";
    private final UserSettingsService userSettingsService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping(value={"data-viewer"})
    public String dataViewer(Model model, HttpServletRequest request) throws JsonProcessingException {
        String gadgetJson = (String)request.getAttribute("gadget");
        DataViewerGadget dataViewerGadget = (DataViewerGadget)((Object)this.objectMapper.readValue(gadgetJson, DataViewerGadget.class));
        String menuId = Optional.ofNullable(((PropertyDto)dataViewerGadget.getProperties().get("menuId")).getValue()).orElse("");
        int pageSize = Integer.parseInt(((PropertyDto)dataViewerGadget.getProperties().get("pageSize")).getValue());
        String username = SessionUtils.getCurrentUserName();
        model.addAttribute("skinPath", (Object)this.getSkinPath(username));
        model.addAttribute("lang", (Object)LocaleContextHolder.getLocale().getLanguage());
        model.addAttribute("gadgetPageSize", (Object)pageSize);
        model.addAttribute("menuId", (Object)menuId);
        return "gadget";
    }

    private String getSkinPath(String username) {
        return this.userSettingsService.getSkinForUser(username).getPath();
    }

    public GadgetController(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }
}

