/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.dto;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class UserDto {
    private String userName;
    private String firstName;
    private String lastName;
    private String email;
    private String number;
    private static LoadingCache<String, UserDto> loadingCache = CacheBuilder.newBuilder().refreshAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build((CacheLoader)new CacheLoader<String, UserDto>(){

        public UserDto load(String userId) throws Exception {
            UserService userService = ServiceFactory.getUserService();
            User user = userService.getUser(userId, new String[0]);
            if (user != null) {
                return new UserDto(user);
            }
            return null;
        }
    });

    private UserDto(User user) {
        this.userName = user.getUserName();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.email = user.getEmail();
        this.number = user.getNumber();
    }

    public static UserDto get(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        try {
            return (UserDto)loadingCache.get((Object)userId);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNumber() {
        return this.number;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserDto)) {
            return false;
        }
        UserDto other = (UserDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        return !(this$number == null ? other$number != null : !this$number.equals(other$number));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        return result;
    }

    public String toString() {
        return "UserDto(userName=" + this.getUserName() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", number=" + this.getNumber() + ")";
    }

    public UserDto() {
    }
}

