/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.dto;

import com.suncode.plugin.dataviewer.service.comment.Comment;
import com.suncode.plugin.dataviewer.web.dto.UserDto;

public class CommentDto {
    private Long id;
    private Boolean bold;
    private Boolean italic;
    private Boolean underline;
    private String color;
    private String content;
    private UserDto author;
    private Long date;

    public static CommentDto from(Comment comment) {
        return CommentDto.builder().id(comment.getId()).content(comment.getContent()).author(UserDto.get(comment.getAuthor())).date(comment.getDate()).bold(comment.getBold()).italic(comment.getItalic()).underline(comment.getUnderline()).color(comment.getColor()).build();
    }

    public Comment buildDomain() {
        return Comment.builder().id(this.id).content(this.content).author(this.author.getUserName()).bold(this.bold).italic(this.italic).underline(this.underline).color(this.color).build();
    }

    public static CommentDtoBuilder builder() {
        return new CommentDtoBuilder();
    }

    public CommentDto() {
    }

    public CommentDto(Long id, Boolean bold, Boolean italic, Boolean underline, String color, String content, UserDto author, Long date) {
        this.id = id;
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.color = color;
        this.content = content;
        this.author = author;
        this.date = date;
    }

    public Long getId() {
        return this.id;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public Boolean getUnderline() {
        return this.underline;
    }

    public String getColor() {
        return this.color;
    }

    public String getContent() {
        return this.content;
    }

    public UserDto getAuthor() {
        return this.author;
    }

    public Long getDate() {
        return this.date;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAuthor(UserDto author) {
        this.author = author;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentDto)) {
            return false;
        }
        CommentDto other = (CommentDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$bold = this.getBold();
        Boolean other$bold = other.getBold();
        if (this$bold == null ? other$bold != null : !((Object)this$bold).equals(other$bold)) {
            return false;
        }
        Boolean this$italic = this.getItalic();
        Boolean other$italic = other.getItalic();
        if (this$italic == null ? other$italic != null : !((Object)this$italic).equals(other$italic)) {
            return false;
        }
        Boolean this$underline = this.getUnderline();
        Boolean other$underline = other.getUnderline();
        if (this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        UserDto this$author = this.getAuthor();
        UserDto other$author = other.getAuthor();
        return !(this$author == null ? other$author != null : !((Object)this$author).equals(other$author));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $bold = this.getBold();
        result = result * 59 + ($bold == null ? 43 : ((Object)$bold).hashCode());
        Boolean $italic = this.getItalic();
        result = result * 59 + ($italic == null ? 43 : ((Object)$italic).hashCode());
        Boolean $underline = this.getUnderline();
        result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        UserDto $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        return result;
    }

    public String toString() {
        return "CommentDto(id=" + this.getId() + ", bold=" + this.getBold() + ", italic=" + this.getItalic() + ", underline=" + this.getUnderline() + ", color=" + this.getColor() + ", content=" + this.getContent() + ", author=" + this.getAuthor() + ", date=" + this.getDate() + ")";
    }

    public static class CommentDtoBuilder {
        private Long id;
        private Boolean bold;
        private Boolean italic;
        private Boolean underline;
        private String color;
        private String content;
        private UserDto author;
        private Long date;

        CommentDtoBuilder() {
        }

        public CommentDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public CommentDtoBuilder bold(Boolean bold) {
            this.bold = bold;
            return this;
        }

        public CommentDtoBuilder italic(Boolean italic) {
            this.italic = italic;
            return this;
        }

        public CommentDtoBuilder underline(Boolean underline) {
            this.underline = underline;
            return this;
        }

        public CommentDtoBuilder color(String color) {
            this.color = color;
            return this;
        }

        public CommentDtoBuilder content(String content) {
            this.content = content;
            return this;
        }

        public CommentDtoBuilder author(UserDto author) {
            this.author = author;
            return this;
        }

        public CommentDtoBuilder date(Long date) {
            this.date = date;
            return this;
        }

        public CommentDto build() {
            return new CommentDto(this.id, this.bold, this.italic, this.underline, this.color, this.content, this.author, this.date);
        }

        public String toString() {
            return "CommentDto.CommentDtoBuilder(id=" + this.id + ", bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", color=" + this.color + ", content=" + this.content + ", author=" + this.author + ", date=" + this.date + ")";
        }
    }
}

