/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.export;

import com.suncode.plugin.dataviewer.configuration.format.DoubleFormat;
import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.plugin.dataviewer.web.dto.CommentDto;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class CellStyleFactory {
    private final SXSSFWorkbook workbook;

    private CellStyleFactory(SXSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public static CellStyleFactory create(SXSSFWorkbook workbook) {
        return new CellStyleFactory(workbook);
    }

    public CellStyle createHeaderCellStyle() {
        CellStyle style = this.workbook.createCellStyle();
        style.setFillPattern(FillPatternType.FINE_DOTS);
        style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = this.createFontStyle();
        style.setFont(font);
        return style;
    }

    private Font createFontStyle() {
        Font font = this.workbook.createFont();
        font.setBold(true);
        font.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        return font;
    }

    public CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public CellStyle createCellStyle(Format format) {
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        this.setDataFormat(style, format);
        return style;
    }

    private void setDataFormat(CellStyle style, @Nullable Format format) {
        if (format == null) {
            return;
        }
        String precisionFormat = this.getPrecisionFormat(format);
        if (precisionFormat == null) {
            return;
        }
        DataFormat dataFormat = this.workbook.createDataFormat();
        style.setDataFormat(dataFormat.getFormat(precisionFormat));
    }

    private String getPrecisionFormat(Format format) {
        if (!(format instanceof DoubleFormat)) {
            return null;
        }
        DoubleFormat doubleFormat = (DoubleFormat)format;
        Integer decimalPrecision = doubleFormat.getDecimalPrecision();
        if (decimalPrecision == null || decimalPrecision < 1) {
            return null;
        }
        return "0." + "0".repeat(decimalPrecision);
    }

    public CellStyle createDateCellStyle() {
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        CreationHelper createHelper = this.workbook.getCreationHelper();
        style.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
        return style;
    }

    public CellStyle createCommentStyle(CommentDto comment) {
        XSSFCellStyle style = (XSSFCellStyle)this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFont((Font)this.createFontForComment(comment));
        return style;
    }

    private XSSFFont createFontForComment(CommentDto comment) {
        XSSFFont font = (XSSFFont)this.workbook.createFont();
        if (Boolean.TRUE.equals(comment.getBold())) {
            font.setBold(true);
        }
        if (Boolean.TRUE.equals(comment.getItalic())) {
            font.setItalic(true);
        }
        if (Boolean.TRUE.equals(comment.getUnderline())) {
            font.setUnderline((byte)1);
        }
        if (StringUtils.isNotBlank((CharSequence)comment.getColor())) {
            font.setColor(new XSSFColor(comment.getColor().getBytes()));
        }
        return font;
    }
}

