/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.export;

import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.plugin.dataviewer.service.export.CellStyleFactory;
import com.suncode.plugin.dataviewer.web.dto.CommentDto;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class CellFactory {
    private final CellStyleFactory cellStyleFactory;

    private CellFactory(SXSSFWorkbook workbook) {
        this.cellStyleFactory = CellStyleFactory.create(workbook);
    }

    public static CellFactory create(SXSSFWorkbook workbook) {
        return new CellFactory(workbook);
    }

    public SXSSFCell createHeaderCell(SXSSFRow row, int columnIndex, String value) {
        SXSSFCell itemCell = row.createCell(columnIndex);
        itemCell.setCellStyle(this.cellStyleFactory.createHeaderCellStyle());
        itemCell.setCellValue((RichTextString)new XSSFRichTextString(value));
        return itemCell;
    }

    public void createCellByType(SXSSFRow row, int columnIndex, Object value, String stringValue, Format format) {
        if (value instanceof Number) {
            try {
                this.createCell(row, (Integer)columnIndex, new BigDecimal(stringValue), format);
            }
            catch (Exception e) {
                this.createCell(row, (Integer)columnIndex, stringValue, format);
            }
        } else if (value instanceof Date) {
            this.createCell(row, (Integer)columnIndex, (Date)value);
        } else if (value instanceof Calendar) {
            this.createCell(row, (Integer)columnIndex, (Calendar)value);
        } else {
            this.createCell(row, (Integer)columnIndex, stringValue, format);
        }
    }

    public void createCell(SXSSFRow row, Integer columnIndex, String value) {
        this.createCell(row, columnIndex, value, null);
    }

    public void createCell(SXSSFRow row, Integer columnIndex, String value, Format format) {
        SXSSFCell itemCell = row.createCell(columnIndex.intValue());
        itemCell.setCellStyle(this.cellStyleFactory.createCellStyle(format));
        String replacedValue = value.replace(",", ".").replace(" ", "");
        if (NumberUtils.isCreatable((String)replacedValue) && replacedValue.matches("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?$") && replacedValue.length() <= 16) {
            Number number = this.toNumber(replacedValue);
            itemCell.setCellValue(number.doubleValue());
            return;
        }
        itemCell.setCellValue((RichTextString)new XSSFRichTextString(value));
    }

    private Number toNumber(String sTest) {
        if (StringUtils.isBlank((CharSequence)sTest)) {
            return null;
        }
        try {
            return Integer.valueOf(sTest);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(sTest);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Float.valueOf(sTest);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return Double.valueOf(sTest);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return null;
                    }
                }
            }
        }
    }

    private void createCell(SXSSFRow row, Integer columnIndex, Number value, Format format) {
        SXSSFCell itemCell = row.createCell(columnIndex.intValue());
        itemCell.setCellValue(Double.parseDouble(value.toString()));
        itemCell.setCellStyle(this.cellStyleFactory.createCellStyle(format));
    }

    private void createCell(SXSSFRow row, Integer columnIndex, Date value) {
        SXSSFCell itemCell = row.createCell(columnIndex.intValue());
        itemCell.setCellValue(value);
        itemCell.setCellStyle(this.cellStyleFactory.createDateCellStyle());
    }

    private void createCell(SXSSFRow row, Integer columnIndex, Calendar value) {
        SXSSFCell itemCell = row.createCell(columnIndex.intValue());
        itemCell.setCellValue(value);
        itemCell.setCellStyle(this.cellStyleFactory.createDateCellStyle());
    }

    public void createCommentContentCell(SXSSFRow row, Integer columnIndex, CommentDto comment) {
        SXSSFCell itemCell = row.createCell(columnIndex.intValue());
        itemCell.setCellValue((RichTextString)new XSSFRichTextString(comment.getContent()));
        itemCell.setCellStyle(this.cellStyleFactory.createCommentStyle(comment));
    }
}

