/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.comment;

import com.suncode.plugin.dataviewer.service.comment.CommentKey;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

@Entity
@Table(name="dv_comments")
@SequenceGenerator(name="dv_comments_seq", sequenceName="dv_comments_id")
public class Comment {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="dv_comments_seq")
    private Long id;
    @ManyToOne
    @JoinColumn(name="comment_key", nullable=false)
    private CommentKey key;
    private String content;
    private String author;
    private Boolean bold;
    private Boolean italic;
    private Boolean underline;
    private String color;
    private Long date;

    public void apply(Comment comment) {
        this.content = comment.getContent();
        this.bold = comment.getBold();
        this.italic = comment.getItalic();
        this.underline = comment.getUnderline();
        this.color = comment.getColor();
    }

    public static CommentBuilder builder() {
        return new CommentBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public CommentKey getKey() {
        return this.key;
    }

    public String getContent() {
        return this.content;
    }

    public String getAuthor() {
        return this.author;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public Boolean getUnderline() {
        return this.underline;
    }

    public String getColor() {
        return this.color;
    }

    public Long getDate() {
        return this.date;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKey(CommentKey key) {
        this.key = key;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$bold = this.getBold();
        Boolean other$bold = other.getBold();
        if (this$bold == null ? other$bold != null : !((Object)this$bold).equals(other$bold)) {
            return false;
        }
        Boolean this$italic = this.getItalic();
        Boolean other$italic = other.getItalic();
        if (this$italic == null ? other$italic != null : !((Object)this$italic).equals(other$italic)) {
            return false;
        }
        Boolean this$underline = this.getUnderline();
        Boolean other$underline = other.getUnderline();
        if (this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        CommentKey this$key = this.getKey();
        CommentKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        return !(this$color == null ? other$color != null : !this$color.equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Comment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $bold = this.getBold();
        result = result * 59 + ($bold == null ? 43 : ((Object)$bold).hashCode());
        Boolean $italic = this.getItalic();
        result = result * 59 + ($italic == null ? 43 : ((Object)$italic).hashCode());
        Boolean $underline = this.getUnderline();
        result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        CommentKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        return result;
    }

    public String toString() {
        return "Comment(id=" + this.getId() + ", key=" + this.getKey() + ", content=" + this.getContent() + ", author=" + this.getAuthor() + ", bold=" + this.getBold() + ", italic=" + this.getItalic() + ", underline=" + this.getUnderline() + ", color=" + this.getColor() + ", date=" + this.getDate() + ")";
    }

    public Comment() {
    }

    public Comment(Long id, CommentKey key, String content, String author, Boolean bold, Boolean italic, Boolean underline, String color, Long date) {
        this.id = id;
        this.key = key;
        this.content = content;
        this.author = author;
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.color = color;
        this.date = date;
    }

    public static class CommentBuilder {
        private Long id;
        private CommentKey key;
        private String content;
        private String author;
        private Boolean bold;
        private Boolean italic;
        private Boolean underline;
        private String color;
        private Long date;

        CommentBuilder() {
        }

        public CommentBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public CommentBuilder key(CommentKey key) {
            this.key = key;
            return this;
        }

        public CommentBuilder content(String content) {
            this.content = content;
            return this;
        }

        public CommentBuilder author(String author) {
            this.author = author;
            return this;
        }

        public CommentBuilder bold(Boolean bold) {
            this.bold = bold;
            return this;
        }

        public CommentBuilder italic(Boolean italic) {
            this.italic = italic;
            return this;
        }

        public CommentBuilder underline(Boolean underline) {
            this.underline = underline;
            return this;
        }

        public CommentBuilder color(String color) {
            this.color = color;
            return this;
        }

        public CommentBuilder date(Long date) {
            this.date = date;
            return this;
        }

        public Comment build() {
            return new Comment(this.id, this.key, this.content, this.author, this.bold, this.italic, this.underline, this.color, this.date);
        }

        public String toString() {
            return "Comment.CommentBuilder(id=" + this.id + ", key=" + this.key + ", content=" + this.content + ", author=" + this.author + ", bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", color=" + this.color + ", date=" + this.date + ")";
        }
    }
}

