/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.menu;

import com.google.common.base.Joiner;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.menu.DataViewerMenu;
import com.suncode.plugin.dataviewer.menu.I18nCustomLocalizedMessage;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuResolver {
    private static final Logger log = LoggerFactory.getLogger(MenuResolver.class);
    private static final String LINK_SUFFIX = "viewer";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private PermissionService permissionService;

    public List<DataViewerMenu> resolveMenus(String pluginKey) {
        try {
            Configuration configuration = this.configurationService.getConfiguration();
            return configuration.getMenus().stream().map(menu -> this.createMenu((Menu)menu, pluginKey)).collect(Collectors.toList());
        }
        catch (Exception ex) {
            log.error("Cannot build any menu tab", (Throwable)ex);
            return new LinkedList<DataViewerMenu>();
        }
    }

    private DataViewerMenu createMenu(Menu menu, String pluginKey) {
        return DataViewerMenu.builder().id(menu.getId()).link(() -> this.buildLink(menu.getId(), pluginKey)).label(new I18nCustomLocalizedMessage(menu.getName())).conditions(Arrays.asList(this.permissionService.createCondition(menu.getId()))).build();
    }

    private String buildLink(String id, String pluginKey) {
        String encodedKey = URLEncoder.encode(pluginKey, "UTF-8");
        String encodedId = URLEncoder.encode(id, "UTF-8");
        String link = Joiner.on((String)"/").join((Object)"/plugin", (Object)encodedKey, new Object[]{encodedId, LINK_SUFFIX});
        return link + "?decorator=noScripts";
    }
}

