/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.defaultView;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.defaultView.DefaultView;
import com.suncode.plugin.framework.defaultView.DefaultViewProvider;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultViewProviderImpl
implements DefaultViewProvider {
    private static final int DATA_VIEWER_ORDER = 20000;
    private static final String DATA_VIEWER_URL_PATTERN = "plugin/%s/%s/viewer";
    private static final String DATA_VIEWER_TAB_URL_PATTERN = "plugin/%s/%s/viewer#/?viewId=%s";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private Plugin plugin;
    private final Translator translator = Translators.get(DefaultViewProviderImpl.class);

    public List<DefaultView> getDefaultViewsForUser(String userId) {
        AtomicInteger counter = new AtomicInteger(1);
        List<Menu> menus = this.getMenusAvailableToUser(userId);
        if (menus.isEmpty()) {
            return List.of();
        }
        LinkedList<DefaultView> defaultViews = new LinkedList<DefaultView>();
        this.getParentDefaultView(menus.get(0)).ifPresent(defaultViews::add);
        for (Menu menu : menus) {
            defaultViews.addAll(this.getDefaultViewsForMenu(menu, counter));
        }
        return defaultViews;
    }

    private List<Menu> getMenusAvailableToUser(String userId) {
        return this.configurationService.getConfiguration().getMenus().stream().filter(menu -> this.permissionService.hasPermissionToMenu(menu.getId())).toList();
    }

    private Optional<DefaultView> getParentDefaultView(Menu menu) {
        if (menu == null) {
            return Optional.empty();
        }
        return Optional.of(new DefaultView("data-viewer", this.translator.getMessage("data.viewer.favourites.parent.name"), this.url(menu), 20000));
    }

    private List<DefaultView> getDefaultViewsForMenu(Menu menu, AtomicInteger counter) {
        if (menu == null) {
            return List.of();
        }
        LinkedList<DefaultView> defaultViews = new LinkedList<DefaultView>();
        defaultViews.add(new DefaultView("data-view-%s".formatted(menu.getId()), menu.getName(), this.url(menu), 20000 + counter.getAndIncrement(), 1));
        List<View> menuTabs = menu.getViews();
        if (menuTabs.size() <= 1) {
            return defaultViews;
        }
        for (View menuTab : menuTabs) {
            defaultViews.add(new DefaultView("data-view-%s-%s".formatted(menu.getId(), menuTab.getId()), menuTab.getName(), this.url(menu, menuTab), 20000 + counter.getAndIncrement(), 2));
        }
        return defaultViews;
    }

    private String url(Menu menu) {
        return DATA_VIEWER_URL_PATTERN.formatted(this.plugin.getKey(), menu.getId());
    }

    private String url(Menu menu, View menuTab) {
        return DATA_VIEWER_TAB_URL_PATTERN.formatted(this.plugin.getKey(), menu.getId(), menuTab.getId());
    }
}

