class ViewNameResolver {
  resolveViewName(view, inputValues) {
    const nameFromTemplate = this.resolveViewNameFromTemplate(view, inputValues);
    return nameFromTemplate ?? view.name;
  }

  resolveViewNameFromTemplate(view, inputValues) {
    if (!view.nameTemplate || !view.nameTemplate.trim().length) {
      return null;
    }

    const variablePattern = /\${([^}]+)}/g;
    let match;
    let variableIds = [];
    while ((match = variablePattern.exec(view.nameTemplate))) {
      variableIds.push(match[1]);
    }

    const replaceVariableValue = (str, variableId, value) => {
      const regex = new RegExp(`\\$\\{${variableId}\\}`, 'g');
      return str.replace(regex, value);
    };

    let finalName = view.nameTemplate;
    for (let i = 0; i < variableIds.length; i++) {
      const variableId = variableIds[i];

      const input = inputValues.find(input => input.id === variableId);
      if (!input) {
        return null;
      }

      if (!input.value || !input.value.toString().trim().length) {
        return null;
      }

      finalName = replaceVariableValue(finalName, variableId, input.value.toString().trim());
    }

    return finalName;
  }
}

export default new ViewNameResolver();
