import { absolutePath, createPath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class ExportService {
  exportExcel(view, sortByAliasId, asc, parameters) {
    let direction = asc == true || asc == null ? 'ASC' : 'DESC';
    let property = sortByAliasId;

    let url = createPath(API_URL + 'data/' + encodeURIComponent(view.id) + '/excel', {
      direction,
      property,
      parameters: JSON.stringify(parameters),
    });
    window.location.href = absolutePath(url);
  }
}

export default new ExportService();
