import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';

class DocumentClassIndexService {
  getDocumentClassIndices(docClassId, start, limit, sortBy, sortDirection) {
    return axios
      .get(absolutePath(`/api/documents/classes/${docClassId}/indices`), {
        params: {
          start: start,
          limit: limit,
          sortBy: sortBy,
          sortDirection: sortDirection,
        },
      })
      .then(response => response.data)
      .catch(error => error.response);
  }

  getDocumentClassIndex(docClassId, docClassIndexId) {
    return axios.get(absolutePath(`/api/documents/classes/${docClassId}/indices/${docClassIndexId}`)).then(response => response.data);
  }

  canDocumentClassIndexBeEdited(docClassId, docClassIndexId) {
    return axios
      .get(absolutePath(`/api/documents/classes/${docClassId}/indices/${docClassIndexId}/canBeEdited`))
      .then(response => response.data);
  }

  getIndexTypes(docClassId) {
    return axios
      .get(absolutePath(`/api/documents/classes/${docClassId}/indices/types`))
      .then(response => response)
      .catch(error => error.response);
  }

  addDocumentClassIndex(docClassId, documentClassIndex) {
    return axios
      .post(absolutePath(`/api/documents/classes/${docClassId}/indices/add`), documentClassIndex)
      .then(response => response)
      .catch(error => error.response);
  }

  updateDocumentClassIndex(docClassId, documentClassIndex) {
    return axios
      .post(absolutePath(`/api/documents/classes/${docClassId}/indices/update`), documentClassIndex)
      .then(response => response)
      .catch(error => error.response);
  }

  deleteDocumentClassIndex(docClassId, docClassIndexId) {
    return axios
      .delete(absolutePath(`/api/documents/classes/${docClassId}/indices/${docClassIndexId}`))
      .then(response => response)
      .catch(error => error.response);
  }

  moveUpDocumentClassIndex(docClassId, docClassIndexId) {
    return axios
      .get(absolutePath(`/api/documents/classes/${docClassId}/indices/${docClassIndexId}/moveUp`))
      .then(response => response)
      .catch(error => error.response);
  }

  export(docClassId, extension, sortBy, sortDirection) {
    const paramsQuery = jQuery.param({
      sortBy,
      sortDirection,
    });
    window.location.href = absolutePath(`api/documents/classes/${docClassId}/indices/export/${extension}?${paramsQuery}`);
  }
}

export default new DocumentClassIndexService();
