/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.configuration;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.plusmpm.util.Authorization;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.configuration.Input;
import com.suncode.plugin.dataviewer.configuration.InputType;
import com.suncode.plugin.dataviewer.configuration.SourceData;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationTranslator;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplier;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory;
import com.suncode.plugin.dataviewer.service.persmission.UserContext;
import com.suncode.plugin.dataviewer.web.util.CacheUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"api/configuration"})
public class ConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ConfigurationTranslator configurationTranslator;
    @Autowired
    private DataSupplierFactory dataSupplierFactory;
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();

    @Autowired
    public ConfigurationController() {
    }

    @ResponseBody
    @Transactional
    @RequestMapping(method={RequestMethod.GET})
    public Configuration getConfiguration(HttpServletResponse response) {
        CacheUtil.noCache(response);
        try {
            Configuration configuration = this.configurationService.getConfiguration();
            this.applyTranslations(configuration);
            this.applyInputTypes(configuration);
            return configuration;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void applyTranslations(Configuration configuration) {
        try {
            this.configurationTranslator.apply(configuration);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void applyInputTypes(Configuration configuration) {
        configuration.getMenus().stream().flatMap(menu -> menu.getViews().stream()).forEach(this::applyInputTypes);
    }

    private void applyInputTypes(View view) {
        SourceData source = view.getSource();
        DataSupplier dataSupplier = this.dataSupplierFactory.getDataSupplier(source.getType(), source.getId());
        Map<String, String> aliasTypes = dataSupplier.getAliasTypes();
        view.getInputs().stream().filter(input -> input.getType() == null).forEach(input -> {
            if (aliasTypes.containsKey(input.getAlias())) {
                String aliasType = (String)aliasTypes.get(input.getAlias());
                try {
                    input.setType(InputType.forValue(aliasType));
                }
                catch (RuntimeException ex) {
                    log.warn("Cannot parse alias type " + aliasType + " to InputType");
                }
            } else {
                input.setType(Input.DEFAULT_INPUT_TYPE);
            }
        });
    }

    @ResponseBody
    @RequestMapping(value={"json"}, method={RequestMethod.GET})
    public Configuration getJson(HttpServletResponse response) {
        CacheUtil.noCache(response);
        try {
            return this.configurationService.getConfiguration();
        }
        catch (Exception e) {
            return null;
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<?> save(@RequestBody String rawConfiguration) throws IOException, SQLException {
        Configuration configuration = null;
        try {
            configuration = (Configuration)this.objectMapper.readValue(rawConfiguration, Configuration.class);
        }
        catch (Exception e) {
            log.info("Can't map JSON to Configuration class", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        String username = UserContext.userName();
        Authorization.checkRight((String)"system", (String)username, (boolean)false, (boolean)false);
        this.configurationService.save(configuration);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

