/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Input;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.SourceData;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.dataviewer.web.api.util.ConfigurationHelper;
import com.suncode.plugin.dataviewer.web.dto.CellValueDto;
import com.suncode.plugin.dataviewer.web.dto.DataResultDto;
import com.suncode.plugin.dataviewer.web.dto.SorterDto;
import com.suncode.plugin.dataviewer.web.util.CacheUtil;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/data"})
public class DataController {
    @Autowired
    private DataSupplierService dataSupplierService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ConfigurationHelper configurationHelper;
    private ObjectMapper mapper = new ObjectMapper();

    @RequestMapping(value={"{viewId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> data(@PathVariable String viewId, @RequestParam(required=false) String parameters, @RequestParam Integer start, @RequestParam Integer limit, SorterDto sorter, HttpServletResponse response) throws IOException {
        CacheUtil.noCache(response);
        Menu menu = this.configurationHelper.findMenuByViewId(viewId);
        this.permissionService.validatePermission(menu.getId());
        View view = this.configurationHelper.findView(viewId, menu);
        Map params = (Map)this.mapper.readValue(parameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        DataResultDto data = this.dataSupplierService.getData(menu.getId(), view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)start, (Integer)limit), new ArrayList<Class<? extends Format>>());
        return this.successResultWithFormattedData(data);
    }

    @RequestMapping(value={"{viewId}/summary"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> summary(@PathVariable String viewId, @RequestParam(required=false) String parameters, @RequestParam Integer start, @RequestParam Integer limit, SorterDto sorter, HttpServletResponse response) throws IOException {
        CacheUtil.noCache(response);
        View view = this.findView(viewId);
        Map params = (Map)this.mapper.readValue(parameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        CountedResult<Map<String, Object>> summary = this.dataSupplierService.getSummaryData(view, params, Pagination.create((Sorter)sorter.getSorter(), (Integer)start, (Integer)limit), new ArrayList<Class<? extends Format>>());
        return this.successResult(summary);
    }

    @RequestMapping(value={"{viewId}/{inputId}/list"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> list(@PathVariable String viewId, @PathVariable String inputId, @RequestParam(value="query") String query, HttpServletResponse response) {
        CacheUtil.noCache(response);
        Input input = this.getInput(viewId, inputId);
        Pagination pagination = this.createSorter();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", query);
        CountedResult<Map<String, Object>> listData = this.dataSupplierService.getFromSource(input.getSource(), parameters, pagination);
        return this.successResult(listData);
    }

    @RequestMapping(value={"{viewId}/{inputId}/defaultValue"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> defaultValue(@PathVariable String viewId, @PathVariable String inputId, HttpServletResponse response) {
        CacheUtil.noCache(response);
        Input input = this.getInput(viewId, inputId);
        Pagination pagination = this.createSorter();
        SourceData defaultValueSourceData = input.getDynamicDefaultValue();
        if (defaultValueSourceData == null) {
            throw new IllegalArgumentException(String.format("Input id=%s in view viewId=%s has no source configured for its default value", viewId, inputId));
        }
        CountedResult<Map<String, Object>> data = this.dataSupplierService.getFromSource(defaultValueSourceData, new HashMap<String, String>(), pagination);
        if (data.getData().size() == 0) {
            throw new IllegalArgumentException(String.format("Datasource return 0 values as default value for viewId=%s and inputId=%s", viewId, inputId));
        }
        Map dataSourceResult = (Map)data.getData().get(0);
        if (dataSourceResult.size() != 1) {
            throw new IllegalArgumentException(String.format("Datasource return %s values as default value for viewId=%s and inputId=%s", dataSourceResult.size(), viewId, inputId));
        }
        Object defaultValue = ((Map)data.getData().get(0)).values().iterator().next();
        return new ResponseEntity(defaultValue, (HttpStatusCode)HttpStatus.OK);
    }

    private Input getInput(String viewId, String inputId) {
        View view = this.findView(viewId);
        return this.findInput(inputId, view);
    }

    private View findView(String viewId) {
        Menu menu = this.configurationHelper.findMenuByViewId(viewId);
        this.permissionService.validatePermission(menu.getId());
        return this.configurationHelper.findView(viewId, menu);
    }

    private Pagination createSorter() {
        Sorter sorter = new Sorter();
        sorter.setProperty("value");
        sorter.setDirection(SortDirection.ASC);
        return Pagination.create((Sorter)sorter, (Integer)0, (Integer)Integer.MAX_VALUE);
    }

    private Input findInput(String inputId, View view) {
        return view.getInputs().stream().filter(input -> input.getId().equals(inputId)).findFirst().orElseThrow(RuntimeException::new);
    }

    private ResponseEntity<?> successResultWithFormattedData(CountedResult<Map<String, CellValueDto>> data) {
        EntityRestResult result = new EntityRestResult();
        result.setSuccess(true);
        result.setMessage(null);
        result.setEntity(data);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    private ResponseEntity<?> successResult(CountedResult<Map<String, Object>> data) {
        EntityRestResult result = new EntityRestResult();
        result.setSuccess(true);
        result.setMessage(null);
        result.setEntity(data);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }
}

